//#pragma LINK_INFO DERIVATIVE "mc9s12p128"

/******************************************************************************
													            Copyright (c) Freescale 2009
File Name    : $RCSfile: main.c,v $

Current Revision :	$Revision: 1.0 $

PURPOSE: main program entry.                       
                                                                          
                                                                       
DESCRIPTION:  function main() providing initial program entry.                                                         
                                                                          
UPDATE HISTORY                                                            
REV  AUTHOR    DATE        DESCRIPTION OF CHANGE                          
---  ------    --------    ---------------------                          
1.0  r28318    09/06/09    - initial coding

     *******************************************************************
     * File created by: Freescale East Kilbride MSG Applications Group *
     *******************************************************************

                                                                          
******************************************************************************/
/*===========================================================================*/
/* Freescale reserves the right to make changes without further notice to any*/
/* product herein to improve reliability, function, or design. Freescale does*/
/* not assume any  liability arising  out  of the  application or use of any */
/* product,  circuit, or software described herein;  neither  does it convey */
/* any license under its patent rights  nor the  rights of others.  Freescale*/
/* products are not designed, intended,  or authorized for use as components */
/* in  systems  intended  for  surgical  implant  into  the  body, or  other */
/* applications intended to support life, or  for any  other application  in */
/* which the failure of the Freescale product  could create a situation where*/
/* personal injury or death may occur. Should Buyer purchase or use Freescale*/
/* products for any such intended  or unauthorized  application, Buyer shall */
/* indemnify and  hold  Freescale  and its officers, employees, subsidiaries,*/
/* affiliates,  and distributors harmless against all claims costs, damages, */
/* and expenses, and reasonable  attorney  fees arising  out of, directly or */
/* indirectly,  any claim of personal injury  or death  associated with such */
/* unintended or unauthorized use, even if such claim alleges that  Freescale*/
/* was negligent regarding the  design  or manufacture of the part. Freescale*/
/* and the Freescale logo* are registered trademarks of Freescale Ltd.       */
/*****************************************************************************/

/************************* Include Files *************************************/
/*general includes */
#include <hidef.h>  /* also includes boolean definitions in stdtypes.h     */
#include <MC9S12P128.h>     /* derivative information */
#include "target.h" 
#include "S12P_peripherals.h" /* includes peripherals definitions and FSL data types */


/************************* typedefs ******************************************/

/************************* #defines ******************************************/

/************************* Constants *****************************************/
#pragma CONST_SEG DEFAULT

/************************* Global Variables **********************************/
#pragma DATA_SEG DEFAULT

/************************* function prototypes *******************************/
#pragma CODE_SEG DEFAULT
/************************* Functions *****************************************/
#pragma CODE_SEG DEFAULT

/******************************************************************************
Function Name  : main
Engineer       : r28318	
Date           : 09/06/09
Parameters     : NONE
Returns        : NONE
Notes          : main routine called by Startup.c. 
******************************************************************************/


void main(void) {
   char x,y;
   char data = 0;
   
      /* initialise the system clock - 32MHz Bus CLK, 4MHz Crystal */
	 CPMUCLKS_PLLSEL = 1; /*select the PLL as the clock source */
	 CPMUOSC = 0xC8;
   while(!CPMUFLG_UPOSC);	/* wait for OSC to stabilise */
   CPMUREFDIV = ((REFCLK_RANGE<<6) | (PLL_DIVIDER-1));       /* Reference Clock / 1 = 4MHz */
   CPMUSYNR = ((VCO_RANGE<<6) | (PLL_MULTIPLIER-1));         /* configure the PLL  x 16 = 64MHz VCO */
   CPMUPOSTDIV = (PLL_POSTDIVIDER-1);      /* Post divider / 1 = 32MHz Bus CLK */
   while(!CPMUFLG_LOCK)	/* wait for PLL to lock */
   {
   }
	 
      /* Initialise the SPI */
   SPICR2 = 0x10; /* 8-Bit transfer width; SS pin is used by the SPI */
   SPIBR =  0x77; /* SPI clock = Bus Clock divided by 2048 = 15.625kHz */
   SPICR1 = 0x56; /* SPI enabled; Master mode; Active high clocks; Slave Select output enabled*/
   

   while(1)
   {
     while(SPISR_SPTEF==0); /* Wait till transmit data register is empty*/
     SPIDRL = data++;       /* Write data to transmit data register */ 
                            /* Writing SPIDR after reading SPISR with SPTEF=1 clears SPTEF */

     /* Delay to seperate SPI transmissions */
     for (x=0; x<100; x++)
     {	
    	for (y=0; y<100; y++)
    	{} 
     }
   }
}

